#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>
#include <ctime>
#include <string>
using namespace std;

struct Item {
    int index;
    int value;
    int weight;
};

bool cmpWeight(const Item &a, const Item &b) {
    return a.weight < b.weight;
}

int main() {
	string filename;
	cout<<"Enter the input file name: ";
	cin>> filename;
	
    ifstream file(filename.c_str());
    if (!file) {
        cerr << "Error opening file." << endl;
        return 1;
    }

    char Wchar, eq;
    double W;
    file >> Wchar >> eq >> W;
    string header;
    getline(file, header);
    getline(file, header);

    vector<Item> items;
    int i, v, w;
    while (file >> i >> v >> w) {
        Item it;
        it.index = i;
        it.value = v;
        it.weight = w;
        items.push_back(it);
    }
    file.close();

    clock_t start = clock();

    sort(items.begin(), items.end(), cmpWeight);

    int totalValue = 0, totalWeight = 0;
    vector<int> chosen;

    for (size_t j = 0; j < items.size(); j++) {
        if (totalWeight + items[j].weight <= W) {
            totalWeight += items[j].weight;
            totalValue += items[j].value;
            chosen.push_back(items[j].index);
        } else {
            continue;
        }
    }

    clock_t end = clock();
    double elapsed = double(end - start) / CLOCKS_PER_SEC;

    cout << "Heuristic by WEIGHT" << endl;
    if (items.size() <= 1000) {
        cout << "Selected items: ";
        for (size_t j = 0; j < chosen.size(); j++) cout << chosen[j] << " ";
        cout << endl;
    } else {
        cout << "Number of selected items: " << chosen.size() << endl;
    }
    cout << "Objective function value = " << totalValue << endl;
    cout << "Total weight = " << totalWeight << " / Capacity = " << W << endl;
    cout << "Running time = " << elapsed << " seconds" << endl;

    return 0;
}


